/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.internal.hyperlink;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.terminal.TerminalPlugin;
import com.aptana.terminal.hyperlink.IHyperlinkDetector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;

public class HyperlinkManager {
    private static final IHyperlink[] NO_HYPERLINKS = new IHyperlink[0];
    private static final String CLASS = "class";
    private static final String HYPERLINK_DETECTOR_EXT_PT = "com.aptana.terminal.terminalHyperlinkDetectors";
    private Map<Integer, IHyperlink[]> fLinks;
    private int fLastHash;
    private IHyperlinkDetector[] fDetectors;
    private ITerminalTextDataReadOnly fTextData;

    public HyperlinkManager(ITerminalTextDataReadOnly textData) {
        this.fTextData = textData;
        this.fLinks = new HashMap<Integer, IHyperlink[]>();
    }

    private synchronized IHyperlinkDetector[] getHyperlinkDetectors() {
        if (this.fDetectors == null) {
            this.fDetectors = new IHyperlinkDetector[0];
            Object[] config = RegistryFactory.getRegistry().getConfigurationElementsFor(HYPERLINK_DETECTOR_EXT_PT);
            if (!ArrayUtil.isEmpty((Object[])config)) {
                ArrayList<IHyperlinkDetector> result = new ArrayList<IHyperlinkDetector>(config.length);
                Object[] objectArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    Object c = objectArray[n2];
                    try {
                        result.add((IHyperlinkDetector)c.createExecutableExtension(CLASS));
                    }
                    catch (CoreException e) {
                        TerminalPlugin.log(e);
                    }
                    ++n2;
                }
                this.fDetectors = result.toArray(new IHyperlinkDetector[result.size()]);
            }
        }
        return this.fDetectors;
    }

    public synchronized IHyperlink[] searchLineForHyperlinks(int line) {
        String text = this.getTerminalText(line);
        int hash = line * 31 + text.hashCode();
        if (hash == this.fLastHash) {
            return this.fLinks.get(line);
        }
        this.fLastHash = hash;
        if (!StringUtil.isEmpty((String)text)) {
            IHyperlink[] newLinks = NO_HYPERLINKS;
            Object[] detectors = this.getHyperlinkDetectors();
            if (!ArrayUtil.isEmpty((Object[])detectors)) {
                ArrayList<IHyperlink> list = new ArrayList<IHyperlink>(detectors.length);
                Object[] objectArray = detectors;
                int n = detectors.length;
                int n2 = 0;
                while (n2 < n) {
                    Object detector = objectArray[n2];
                    IHyperlink[] partialNewLinks = detector.detectHyperlinks(text);
                    if (partialNewLinks != null && partialNewLinks.length > 0) {
                        list.addAll(Arrays.asList(partialNewLinks));
                    }
                    ++n2;
                }
                newLinks = list.toArray(new IHyperlink[list.size()]);
            }
            this.fLinks.put(line, newLinks);
            return newLinks;
        }
        return NO_HYPERLINKS;
    }

    private String getTerminalText(int line) {
        char[] c = this.fTextData.getChars(line);
        if (c != null && c.length > 0) {
            return new String(c);
        }
        return "";
    }
}

